package org.openqa.selenium.devtools.v132.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Pair of reporting metadata details for a candidate URL for `selectURL()`.
 */
public class SharedStorageReportingMetadata {

    private final java.lang.String eventType;

    private final java.lang.String reportingUrl;

    public SharedStorageReportingMetadata(java.lang.String eventType, java.lang.String reportingUrl) {
        this.eventType = java.util.Objects.requireNonNull(eventType, "eventType is required");
        this.reportingUrl = java.util.Objects.requireNonNull(reportingUrl, "reportingUrl is required");
    }

    public java.lang.String getEventType() {
        return eventType;
    }

    public java.lang.String getReportingUrl() {
        return reportingUrl;
    }

    private static SharedStorageReportingMetadata fromJson(JsonInput input) {
        java.lang.String eventType = null;
        java.lang.String reportingUrl = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "eventType":
                    eventType = input.nextString();
                    break;
                case "reportingUrl":
                    reportingUrl = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageReportingMetadata(eventType, reportingUrl);
    }
}
