/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.bidi.script.ArrayLocalValue;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.DateLocalValue;
import org.openqa.selenium.bidi.script.MapLocalValue;
import org.openqa.selenium.bidi.script.ObjectLocalValue;
import org.openqa.selenium.bidi.script.PrimitiveProtocolValue;
import org.openqa.selenium.bidi.script.PrimitiveType;
import org.openqa.selenium.bidi.script.RegExpValue;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;
import org.openqa.selenium.bidi.script.SetLocalValue;
import org.openqa.selenium.json.Json;

public abstract class LocalValue {
    private static Json JSON = new Json();

    public abstract Map<String, Object> toJson();

    public static LocalValue stringValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.STRING, value);
    }

    public static LocalValue numberValue(long value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(double value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(SpecialNumberType specialNumber) {
        return new PrimitiveProtocolValue(PrimitiveType.SPECIAL_NUMBER, specialNumber.toString());
    }

    public static LocalValue undefinedValue() {
        return new PrimitiveProtocolValue(PrimitiveType.UNDEFINED);
    }

    public static LocalValue nullValue() {
        return new PrimitiveProtocolValue(PrimitiveType.NULL);
    }

    public static LocalValue booleanValue(boolean value) {
        return new PrimitiveProtocolValue(PrimitiveType.BOOLEAN, value);
    }

    public static LocalValue bigIntValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.BIGINT, value);
    }

    public static LocalValue arrayValue(List<LocalValue> value) {
        return new ArrayLocalValue(value);
    }

    public static LocalValue dateValue(String value) {
        return new DateLocalValue(value);
    }

    public static LocalValue mapValue(Map<Object, LocalValue> value) {
        return new MapLocalValue(value);
    }

    public static LocalValue objectValue(Map<Object, LocalValue> value) {
        return new ObjectLocalValue(value);
    }

    public static LocalValue regExpValue(String pattern) {
        return new RegExpValue(pattern);
    }

    public static LocalValue regExpValue(String pattern, String flags) {
        return new RegExpValue(pattern, flags);
    }

    public static LocalValue setValue(Set<LocalValue> value) {
        return new SetLocalValue(value);
    }

    public static LocalValue channelValue(String channelId) {
        return new ChannelValue(channelId);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options) {
        return new ChannelValue(channelId, options);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options, ResultOwnership resultOwnership) {
        return new ChannelValue(channelId, options, resultOwnership);
    }

    public static LocalValue remoteReference(String handle, String sharedId) {
        return new RemoteReference(handle, sharedId);
    }

    public static LocalValue remoteReference(RemoteReference.Type type, String id) {
        return new RemoteReference(type, id);
    }

    public static LocalValue getArgument(Object arg) {
        LocalValue localValue = null;
        if (arg instanceof String) {
            switch ((String)arg) {
                case "undefined": {
                    localValue = LocalValue.undefinedValue();
                    break;
                }
                case "null": {
                    localValue = LocalValue.nullValue();
                    break;
                }
                case "-Infinity": {
                    localValue = LocalValue.numberValue(SpecialNumberType.MINUS_INFINITY);
                    break;
                }
                case "Infinity": {
                    localValue = LocalValue.numberValue(SpecialNumberType.INFINITY);
                    break;
                }
                case "NaN": {
                    localValue = LocalValue.numberValue(SpecialNumberType.NAN);
                    break;
                }
                case "-0": {
                    localValue = LocalValue.numberValue(SpecialNumberType.MINUS_ZERO);
                    break;
                }
                default: {
                    localValue = LocalValue.stringValue((String)arg);
                    break;
                }
            }
        } else if (arg instanceof Number) {
            if (arg instanceof Integer || arg instanceof Long) {
                localValue = LocalValue.numberValue(((Number)arg).longValue());
            } else if (arg instanceof Double || arg instanceof Float) {
                localValue = LocalValue.numberValue(((Number)arg).doubleValue());
            } else if (arg instanceof BigInteger) {
                localValue = LocalValue.bigIntValue(arg.toString());
            }
        } else if (arg instanceof Boolean) {
            localValue = LocalValue.booleanValue((Boolean)arg);
        } else if (arg instanceof Instant) {
            localValue = LocalValue.dateValue(((Instant)arg).toString());
        } else if (arg instanceof Map) {
            HashMap<Object, LocalValue> map = new HashMap<Object, LocalValue>();
            for (Map.Entry entry : ((Map)arg).entrySet()) {
                Object key = entry.getKey() instanceof String ? entry.getKey() : LocalValue.getArgument(entry.getKey());
                map.put(key, LocalValue.getArgument(entry.getValue()));
            }
            localValue = LocalValue.mapValue(map);
        } else if (arg instanceof List) {
            ArrayList<LocalValue> values = new ArrayList<LocalValue>();
            ((List)arg).forEach(value -> values.add(LocalValue.getArgument(value)));
            localValue = LocalValue.arrayValue(values);
        } else if (arg instanceof Set) {
            HashSet<LocalValue> values = new HashSet<LocalValue>();
            ((Set)arg).forEach(value -> values.add(LocalValue.getArgument(value)));
            localValue = LocalValue.setValue(values);
        } else if (arg instanceof RegExpValue) {
            localValue = (RegExpValue)arg;
        } else {
            String json = JSON.toJson(arg);
            Map objectMap = (Map)JSON.toType(json, Map.class);
            HashMap<Object, LocalValue> map = new HashMap<Object, LocalValue>();
            for (Map.Entry entry : objectMap.entrySet()) {
                Object key = entry.getKey() instanceof String ? entry.getKey() : LocalValue.getArgument(entry.getKey());
                map.put(key, LocalValue.getArgument(entry.getValue()));
            }
            localValue = LocalValue.objectValue(map);
            return localValue;
        }
        return localValue;
    }

    static enum SpecialNumberType {
        NAN("NaN"),
        MINUS_ZERO("-0"),
        INFINITY("Infinity"),
        MINUS_INFINITY("-Infinity");

        private final String type;

        private SpecialNumberType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

