/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_41;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class InspectContainer {
    private static final Logger LOG = Logger.getLogger(InspectContainer.class.getName());
    private static final Json JSON = new Json();
    private final HttpHandler client;

    public InspectContainer(HttpHandler client) {
        this.client = Require.nonNull("HTTP client", client);
    }

    public ContainerInfo apply(ContainerId id) {
        Require.nonNull("Container id", id);
        HttpResponse res = this.client.execute((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/containers/%s/json", "1.41", id)).addHeader("Content-Type", "text/plain"));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to inspect container " + String.valueOf(id));
        }
        Map rawInspectInfo = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
        Map networkSettings = (Map)rawInspectInfo.get("NetworkSettings");
        Map networks = (Map)networkSettings.get("Networks");
        Map.Entry firstNetworkEntry = networks.entrySet().iterator().next();
        Map networkValues = (Map)firstNetworkEntry.getValue();
        String networkName = (String)firstNetworkEntry.getKey();
        String ip = networkValues.get("IPAddress").toString();
        ArrayList mounts = (ArrayList)rawInspectInfo.get("Mounts");
        List<Map<String, Object>> mountedVolumes = mounts.stream().map(mount -> (Map)mount).collect(Collectors.toList());
        Map<String, Object> hostConfig = rawInspectInfo.getOrDefault("HostConfig", Collections.emptyMap());
        return new ContainerInfo(id, ip, mountedVolumes, networkName, hostConfig);
    }
}

