/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.preparsed.persisted;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.PublicApi;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.persisted.PersistedQueryCache;
import graphql.execution.preparsed.persisted.PersistedQueryCacheMiss;
import graphql.execution.preparsed.persisted.PersistedQueryNotFound;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

@PublicApi
public class InMemoryPersistedQueryCache
implements PersistedQueryCache {
    private final Map<Object, PreparsedDocumentEntry> cache = new ConcurrentHashMap<Object, PreparsedDocumentEntry>();
    private final Map<Object, String> knownQueries;

    public InMemoryPersistedQueryCache(Map<Object, String> knownQueries) {
        this.knownQueries = Assert.assertNotNull(knownQueries);
    }

    public Map<Object, String> getKnownQueries() {
        return this.knownQueries;
    }

    @Override
    public CompletableFuture<PreparsedDocumentEntry> getPersistedQueryDocumentAsync(Object persistedQueryId, ExecutionInput executionInput, PersistedQueryCacheMiss onCacheMiss) throws PersistedQueryNotFound {
        PreparsedDocumentEntry documentEntry = this.cache.compute(persistedQueryId, (k, v) -> {
            if (v != null) {
                return v;
            }
            String queryText = executionInput.getQuery();
            if (queryText == null || queryText.isEmpty() || queryText.equals("PersistedQueryMarker")) {
                queryText = this.knownQueries.get(persistedQueryId);
            }
            if (queryText == null) {
                throw new PersistedQueryNotFound(persistedQueryId);
            }
            return onCacheMiss.apply(queryText);
        });
        return CompletableFuture.completedFuture(documentEntry);
    }

    public static Builder newInMemoryPersistedQueryCache() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Object, String> knownQueries = new HashMap<Object, String>();

        public Builder addQuery(Object key, String queryText) {
            this.knownQueries.put(key, queryText);
            return this;
        }

        public InMemoryPersistedQueryCache build() {
            return new InMemoryPersistedQueryCache(this.knownQueries);
        }
    }
}

