/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.remote.SessionId;

public class Session
implements Serializable {
    private final SessionId id;
    private final URI uri;
    private final Capabilities stereotype;
    private final Capabilities capabilities;
    private final Instant startTime;

    public Session(SessionId id, URI uri, Capabilities stereotype, Capabilities capabilities, Instant startTime) {
        this.id = Require.nonNull("Session ID", id);
        this.uri = Require.nonNull("Where the session is running", uri);
        this.startTime = Require.nonNull("Start time", startTime);
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
        this.capabilities = ImmutableCapabilities.copyOf(Require.nonNull("Session capabilities", capabilities));
    }

    public SessionId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public Capabilities getStereotype() {
        return this.stereotype;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("capabilities", this.getCapabilities());
        toReturn.put("sessionId", this.getId().toString());
        toReturn.put("stereotype", this.getStereotype());
        toReturn.put("start", this.getStartTime());
        toReturn.put("uri", this.getUri());
        return Collections.unmodifiableMap(toReturn);
    }

    private static Session fromJson(JsonInput input) {
        SessionId id = null;
        URI uri = null;
        ImmutableCapabilities caps = null;
        Capabilities stereotype = null;
        Instant start = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    caps = ImmutableCapabilities.copyOf((Capabilities)input.read((Type)((Object)Capabilities.class)));
                    continue block14;
                }
                case "sessionId": {
                    id = (SessionId)input.read((Type)((Object)SessionId.class));
                    continue block14;
                }
                case "start": {
                    start = (Instant)input.read((Type)((Object)Instant.class));
                    continue block14;
                }
                case "stereotype": {
                    stereotype = (Capabilities)input.read((Type)((Object)Capabilities.class));
                    continue block14;
                }
                case "uri": {
                    uri = (URI)input.read((Type)((Object)URI.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Session(id, uri, stereotype, caps, start);
    }

    public boolean equals(Object that) {
        if (!(that instanceof Session)) {
            return false;
        }
        Session session = (Session)that;
        return Objects.equals(this.id, session.getId()) && Objects.equals(this.uri, session.getUri());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri);
    }
}

