/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Field;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class ScalarLeaves
extends AbstractRule {
    public ScalarLeaves(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        GraphQLOutputType type = this.getValidationContext().getOutputType();
        if (type == null) {
            return;
        }
        if (GraphQLTypeUtil.isLeaf(type)) {
            if (field.getSelectionSet() != null) {
                String message = this.i18n(ValidationErrorType.SubselectionNotAllowed, "ScalarLeaves.subselectionOnLeaf", GraphQLTypeUtil.simplePrint(type), field.getName());
                this.addError(ValidationErrorType.SubselectionNotAllowed, field.getSourceLocation(), message);
            }
        } else if (field.getSelectionSet() == null) {
            String message = this.i18n(ValidationErrorType.SubselectionRequired, "ScalarLeaves.subselectionRequired", GraphQLTypeUtil.simplePrint(type), field.getName());
            this.addError(ValidationErrorType.SubselectionRequired, field.getSourceLocation(), message);
        }
    }
}

