/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.PublicApi;
import graphql.introspection.IntrospectionQuery;
import graphql.schema.GraphQLSchema;
import java.util.Map;

@PublicApi
@Deprecated(since="2023-10-04")
public class DiffSet {
    private final Map<String, Object> introspectionOld;
    private final Map<String, Object> introspectionNew;

    public DiffSet(Map<String, Object> introspectionOld, Map<String, Object> introspectionNew) {
        this.introspectionOld = introspectionOld;
        this.introspectionNew = introspectionNew;
    }

    public Map<String, Object> getOld() {
        return this.introspectionOld;
    }

    public Map<String, Object> getNew() {
        return this.introspectionNew;
    }

    public static DiffSet diffSet(Map<String, Object> introspectionOld, Map<String, Object> introspectionNew) {
        return new DiffSet(introspectionOld, introspectionNew);
    }

    public static DiffSet diffSet(GraphQLSchema schemaOld, GraphQLSchema schemaNew) {
        Map<String, Object> introspectionOld = DiffSet.introspect(schemaOld);
        Map<String, Object> introspectionNew = DiffSet.introspect(schemaNew);
        return DiffSet.diffSet(introspectionOld, introspectionNew);
    }

    private static Map<String, Object> introspect(GraphQLSchema schema) {
        GraphQL gql = GraphQL.newGraphQL(schema).build();
        ExecutionResult result = gql.execute(IntrospectionQuery.INTROSPECTION_QUERY);
        Assert.assertTrue(result.getErrors().size() == 0, () -> "The schema has errors during Introspection");
        return (Map)result.getData();
    }
}

