/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.TempDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TempDirectoryTest {
    @Test
    public void testCreatePath() throws IOException {
        TempDirectory ref;
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            ref = tempDir;
            Assertions.assertTrue((boolean)FileUtils.isEmptyDirectory((File)tempDir.toFile()));
        }
        Assertions.assertFalse((boolean)Files.exists(ref.get(), new LinkOption[0]));
    }

    @Test
    public void testCreateString() throws IOException {
        TempDirectory ref;
        try (TempDirectory tempDir = TempDirectory.create(Paths.get("target", new String[0]), this.getClass().getCanonicalName(), new FileAttribute[0]);){
            ref = tempDir;
            Assertions.assertTrue((boolean)FileUtils.isEmptyDirectory((File)tempDir.toFile()));
        }
        Assertions.assertFalse((boolean)Files.exists(ref.get(), new LinkOption[0]));
    }
}

