/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import org.apache.commons.io.ByteOrderMark;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteOrderMarkTest {
    private static final ByteOrderMark TEST_BOM_1 = new ByteOrderMark("test1", new int[]{1});
    private static final ByteOrderMark TEST_BOM_2 = new ByteOrderMark("test2", new int[]{1, 2});
    private static final ByteOrderMark TEST_BOM_3 = new ByteOrderMark("test3", new int[]{1, 2, 3});

    @Test
    public void testConstantCharsetNames() {
        Assertions.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_8.getCharsetName()));
        Assertions.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16BE.getCharsetName()));
        Assertions.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16LE.getCharsetName()));
        Assertions.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_32BE.getCharsetName()));
        Assertions.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_32LE.getCharsetName()));
    }

    @Test
    public void testConstructorExceptions() {
        Assertions.assertThrows(NullPointerException.class, () -> new ByteOrderMark(null, new int[]{1, 2, 3}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteOrderMark("", new int[]{1, 2, 3}));
        Assertions.assertThrows(NullPointerException.class, () -> new ByteOrderMark("a", (int[])null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteOrderMark("b", new int[0]));
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)ByteOrderMark.UTF_16BE, (Object)ByteOrderMark.UTF_16BE);
        Assertions.assertEquals((Object)ByteOrderMark.UTF_16LE, (Object)ByteOrderMark.UTF_16LE);
        Assertions.assertEquals((Object)ByteOrderMark.UTF_32BE, (Object)ByteOrderMark.UTF_32BE);
        Assertions.assertEquals((Object)ByteOrderMark.UTF_32LE, (Object)ByteOrderMark.UTF_32LE);
        Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)ByteOrderMark.UTF_8);
        Assertions.assertNotEquals((Object)ByteOrderMark.UTF_8, (Object)ByteOrderMark.UTF_16BE);
        Assertions.assertNotEquals((Object)ByteOrderMark.UTF_8, (Object)ByteOrderMark.UTF_16LE);
        Assertions.assertNotEquals((Object)ByteOrderMark.UTF_8, (Object)ByteOrderMark.UTF_32BE);
        Assertions.assertNotEquals((Object)ByteOrderMark.UTF_8, (Object)ByteOrderMark.UTF_32LE);
        Assertions.assertEquals((Object)TEST_BOM_1, (Object)TEST_BOM_1, (String)"test1 equals");
        Assertions.assertEquals((Object)TEST_BOM_2, (Object)TEST_BOM_2, (String)"test2 equals");
        Assertions.assertEquals((Object)TEST_BOM_3, (Object)TEST_BOM_3, (String)"test3 equals");
        Assertions.assertNotEquals((Object)TEST_BOM_1, (Object)new Object(), (String)"Object not equal");
        Assertions.assertNotEquals((Object)TEST_BOM_1, (Object)new ByteOrderMark("1a", new int[]{2}), (String)"test1-1 not equal");
        Assertions.assertNotEquals((Object)TEST_BOM_1, (Object)new ByteOrderMark("1b", new int[]{1, 2}), (String)"test1-2 not test2");
        Assertions.assertNotEquals((Object)TEST_BOM_2, (Object)new ByteOrderMark("2", new int[]{1, 1}), (String)"test2 not equal");
        Assertions.assertNotEquals((Object)TEST_BOM_3, (Object)new ByteOrderMark("3", new int[]{1, 2, 4}), (String)"test3 not equal");
    }

    @Test
    public void testGetBytes() {
        Assertions.assertArrayEquals((byte[])TEST_BOM_1.getBytes(), (byte[])new byte[]{1}, (String)"test1 bytes");
        ByteOrderMarkTest.TEST_BOM_1.getBytes()[0] = 2;
        Assertions.assertArrayEquals((byte[])TEST_BOM_1.getBytes(), (byte[])new byte[]{1}, (String)"test1 bytes");
        Assertions.assertArrayEquals((byte[])TEST_BOM_2.getBytes(), (byte[])new byte[]{1, 2}, (String)"test1 bytes");
        Assertions.assertArrayEquals((byte[])TEST_BOM_3.getBytes(), (byte[])new byte[]{1, 2, 3}, (String)"test1 bytes");
    }

    @Test
    public void testGetCharsetName() {
        Assertions.assertEquals((Object)"test1", (Object)TEST_BOM_1.getCharsetName(), (String)"test1 name");
        Assertions.assertEquals((Object)"test2", (Object)TEST_BOM_2.getCharsetName(), (String)"test2 name");
        Assertions.assertEquals((Object)"test3", (Object)TEST_BOM_3.getCharsetName(), (String)"test3 name");
    }

    @Test
    public void testGetInt() {
        Assertions.assertEquals((int)1, (int)TEST_BOM_1.get(0), (String)"test1 get(0)");
        Assertions.assertEquals((int)1, (int)TEST_BOM_2.get(0), (String)"test2 get(0)");
        Assertions.assertEquals((int)2, (int)TEST_BOM_2.get(1), (String)"test2 get(1)");
        Assertions.assertEquals((int)1, (int)TEST_BOM_3.get(0), (String)"test3 get(0)");
        Assertions.assertEquals((int)2, (int)TEST_BOM_3.get(1), (String)"test3 get(1)");
        Assertions.assertEquals((int)3, (int)TEST_BOM_3.get(2), (String)"test3 get(2)");
    }

    @Test
    public void testHashCode() {
        int bomClassHash = ByteOrderMark.class.hashCode();
        Assertions.assertEquals((int)(bomClassHash + 1), (int)TEST_BOM_1.hashCode(), (String)"hash test1 ");
        Assertions.assertEquals((int)(bomClassHash + 3), (int)TEST_BOM_2.hashCode(), (String)"hash test2 ");
        Assertions.assertEquals((int)(bomClassHash + 6), (int)TEST_BOM_3.hashCode(), (String)"hash test3 ");
    }

    @Test
    public void testLength() {
        Assertions.assertEquals((int)1, (int)TEST_BOM_1.length(), (String)"test1 length");
        Assertions.assertEquals((int)2, (int)TEST_BOM_2.length(), (String)"test2 length");
        Assertions.assertEquals((int)3, (int)TEST_BOM_3.length(), (String)"test3 length");
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ByteOrderMark[test1: 0x1]", (Object)TEST_BOM_1.toString(), (String)"test1 ");
        Assertions.assertEquals((Object)"ByteOrderMark[test2: 0x1,0x2]", (Object)TEST_BOM_2.toString(), (String)"test2 ");
        Assertions.assertEquals((Object)"ByteOrderMark[test3: 0x1,0x2,0x3]", (Object)TEST_BOM_3.toString(), (String)"test3 ");
    }
}

