/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TestArguments;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PathUtilsTest
extends TestArguments {
    private static final String TEST_JAR_NAME = "test.jar";
    private static final String TEST_JAR_PATH = "src/test/resources/org/apache/commons/io/test.jar";
    private static final String PATH_FIXTURE = "NOTICE.txt";
    @TempDir
    public Path tempDir;

    private FileSystem openArchive(Path p, boolean createNew) throws IOException {
        FileSystem archive;
        if (createNew) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            URI fileUri = p.toAbsolutePath().toUri();
            URI uri = URI.create("jar:" + fileUri.toASCIIString());
            archive = FileSystems.newFileSystem(uri, env, null);
        } else {
            archive = FileSystems.newFileSystem(p, (ClassLoader)null);
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyDirectoryForDifferentFilesystemsWithAbsolutePath() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]).toAbsolutePath();
        try {
            Path archivePath = Paths.get(TEST_JAR_PATH, new String[0]);
            try (FileSystem archive = this.openArchive(archivePath, false);){
                Path sourceDir = archive.getPath("dir1", new String[0]);
                PathUtils.copyDirectory((Path)sourceDir, (Path)tempDir, (CopyOption[])new CopyOption[0]);
                Assertions.assertTrue((boolean)Files.exists(tempDir.resolve("f1"), new LinkOption[0]));
                sourceDir = archive.getPath("/next", new String[0]);
                PathUtils.copyDirectory((Path)sourceDir, (Path)tempDir, (CopyOption[])new CopyOption[0]);
                Assertions.assertTrue((boolean)Files.exists(tempDir.resolve("dir"), new LinkOption[0]));
            }
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyDirectoryForDifferentFilesystemsWithAbsolutePathReverse() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try (FileSystem archive = this.openArchive(tempDir.resolve(TEST_JAR_NAME), true);){
            Path targetDir = archive.getPath("target", new String[0]);
            Files.createDirectory(targetDir, new FileAttribute[0]);
            Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]).toAbsolutePath();
            PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("dirs-a-file-size-1"), new LinkOption[0]));
            targetDir = archive.getPath("/", new String[0]);
            PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("dirs-a-file-size-1"), new LinkOption[0]));
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyDirectoryForDifferentFilesystemsWithRelativePath() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try {
            Path archivePath = Paths.get(TEST_JAR_PATH, new String[0]);
            try (FileSystem archive = this.openArchive(archivePath, false);
                 FileSystem targetArchive = this.openArchive(tempDir.resolve(TEST_JAR_NAME), true);){
                Path targetDir = targetArchive.getPath("targetDir", new String[0]);
                Files.createDirectory(targetDir, new FileAttribute[0]);
                Path sourceDir = archive.getPath("next", new String[0]);
                PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
                Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("dir"), new LinkOption[0]));
                sourceDir = archive.getPath("/dir1", new String[0]);
                PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
                Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("f1"), new LinkOption[0]));
            }
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyDirectoryForDifferentFilesystemsWithRelativePathReverse() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try (FileSystem archive = this.openArchive(tempDir.resolve(TEST_JAR_NAME), true);){
            Path targetDir = archive.getPath("target", new String[0]);
            Files.createDirectory(targetDir, new FileAttribute[0]);
            Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]);
            PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("dirs-a-file-size-1"), new LinkOption[0]));
            targetDir = archive.getPath("/", new String[0]);
            PathUtils.copyDirectory((Path)sourceDir, (Path)targetDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetDir.resolve("dirs-a-file-size-1"), new LinkOption[0]));
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFile() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try {
            Path sourceFile = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);
            Path targetFile = PathUtils.copyFileToDirectory((Path)sourceFile, (Path)tempDir, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((boolean)Files.exists(targetFile, new LinkOption[0]));
            Assertions.assertEquals((long)Files.size(sourceFile), (long)Files.size(targetFile));
        }
        finally {
            PathUtils.deleteDirectory((Path)tempDir);
        }
    }

    @Test
    public void testCreateDirectoriesAlreadyExists() throws IOException {
        Assertions.assertEquals((Object)this.tempDir.getParent(), (Object)PathUtils.createParentDirectories((Path)this.tempDir, (FileAttribute[])new FileAttribute[0]));
    }

    @Test
    public void testCreateDirectoriesNew() throws IOException {
        Assertions.assertEquals((Object)this.tempDir, (Object)PathUtils.createParentDirectories((Path)this.tempDir.resolve("child"), (FileAttribute[])new FileAttribute[0]));
    }

    @Test
    public void testIsDirectory() throws IOException {
        Assertions.assertFalse((boolean)PathUtils.isDirectory(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertTrue((boolean)PathUtils.isDirectory((Path)this.tempDir, (LinkOption[])new LinkOption[0]));
        Path testFile1 = Files.createTempFile(this.tempDir, "prefix", null, new FileAttribute[0]);
        Assertions.assertFalse((boolean)PathUtils.isDirectory((Path)testFile1, (LinkOption[])new LinkOption[0]));
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        Files.delete(tempDir);
        Assertions.assertFalse((boolean)PathUtils.isDirectory((Path)tempDir, (LinkOption[])new LinkOption[0]));
    }

    @Test
    public void testIsRegularFile() throws IOException {
        Assertions.assertFalse((boolean)PathUtils.isRegularFile(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertFalse((boolean)PathUtils.isRegularFile((Path)this.tempDir, (LinkOption[])new LinkOption[0]));
        Path testFile1 = Files.createTempFile(this.tempDir, "prefix", null, new FileAttribute[0]);
        Assertions.assertTrue((boolean)PathUtils.isRegularFile((Path)testFile1, (LinkOption[])new LinkOption[0]));
        Files.delete(testFile1);
        Assertions.assertFalse((boolean)PathUtils.isRegularFile((Path)testFile1, (LinkOption[])new LinkOption[0]));
    }

    @Test
    public void testNewDirectoryStream() throws Exception {
        NameFileFilter pathFilter = new NameFileFilter(PATH_FIXTURE);
        try (DirectoryStream stream = PathUtils.newDirectoryStream((Path)PathUtils.current(), (PathFilter)pathFilter);){
            Iterator iterator = stream.iterator();
            Path path = (Path)iterator.next();
            Assertions.assertEquals((Object)PATH_FIXTURE, (Object)path.getFileName().toString());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }
}

