/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.output.LockableFileWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LockableFileWriterTest {
    @TempDir
    public File temporaryFolder;
    private File file;
    private File lockDir;
    private File lockFile;
    private File altLockDir;
    private File altLockFile;

    @BeforeEach
    public void setUp() {
        this.file = new File(this.temporaryFolder, "testlockfile");
        this.lockDir = new File(System.getProperty("java.io.tmpdir"));
        this.lockFile = new File(this.lockDir, this.file.getName() + ".lck");
        this.altLockDir = this.temporaryFolder;
        this.altLockFile = new File(this.altLockDir, this.file.getName() + ".lck");
    }

    @Test
    public void testFileLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            Object msg;
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
            try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
                Assertions.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assertions.assertTrue((boolean)((String)msg).startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
                Assertions.assertTrue((boolean)this.file.exists());
                Assertions.assertTrue((boolean)this.lockFile.exists());
            }
            try {
                LockableFileWriter lfw3 = new LockableFileWriter(this.file);
                msg = null;
                try {
                    Assertions.fail((String)"Somehow able to open a locked file. ");
                }
                catch (Throwable throwable) {
                    msg = throwable;
                    throw throwable;
                }
                finally {
                    if (lfw3 != null) {
                        if (msg != null) {
                            try {
                                lfw3.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)msg).addSuppressed(throwable);
                            }
                        } else {
                            lfw3.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assertions.assertTrue((boolean)((String)msg).startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
                Assertions.assertTrue((boolean)this.file.exists());
                Assertions.assertTrue((boolean)this.lockFile.exists());
            }
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testAlternateLockDir() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file, "UTF-8", true, this.altLockDir.getAbsolutePath());){
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.altLockFile.exists());
            try (LockableFileWriter lfw2 = new LockableFileWriter(this.file, StandardCharsets.UTF_8, true, this.altLockDir.getAbsolutePath());){
                Assertions.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                Assertions.assertTrue((boolean)msg.startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
                Assertions.assertTrue((boolean)this.file.exists());
                Assertions.assertTrue((boolean)this.altLockFile.exists());
            }
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.altLockFile.exists());
    }

    @Test
    public void testFileNotLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        var2_2 = null;
        try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_encoding_badEncoding() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter(this.file, "BAD-ENCODE");){
            Assertions.fail();
        }
        catch (UnsupportedCharsetException ex) {
            Assertions.assertFalse((boolean)this.file.exists());
            Assertions.assertFalse((boolean)this.lockFile.exists());
        }
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_directory() {
        try (LockableFileWriter writer = new LockableFileWriter(this.temporaryFolder);){
            Assertions.fail();
        }
        catch (IOException ex) {
            Assertions.assertFalse((boolean)this.file.exists());
            Assertions.assertFalse((boolean)this.lockFile.exists());
        }
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_nullFile() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter((File)null);){
            Assertions.fail();
        }
        catch (NullPointerException ex) {
            Assertions.assertFalse((boolean)this.file.exists());
            Assertions.assertFalse((boolean)this.lockFile.exists());
        }
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_fileName_nullFile() throws IOException {
        try (LockableFileWriter writer = new LockableFileWriter((String)null);){
            Assertions.fail();
        }
        catch (NullPointerException ex) {
            Assertions.assertFalse((boolean)this.file.exists());
            Assertions.assertFalse((boolean)this.lockFile.exists());
        }
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }
}

