/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import org.apache.commons.io.output.AppendableWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AppendableWriterTest {
    private AppendableWriter<StringBuilder> out;

    @BeforeEach
    public void setUp() {
        this.out = new AppendableWriter((Appendable)new StringBuilder());
    }

    @Test
    public void testWriteInt() throws Exception {
        this.out.write(70);
        Assertions.assertEquals((Object)"F", (Object)((StringBuilder)this.out.getAppendable()).toString());
    }

    @Test
    public void testWriteChars() throws Exception {
        String testData = "ABCD";
        this.out.write("ABCD".toCharArray());
        Assertions.assertEquals((Object)"ABCD", (Object)((StringBuilder)this.out.getAppendable()).toString());
    }

    @Test
    public void testWriteString() throws Exception {
        String testData = "ABCD";
        this.out.write("ABCD");
        Assertions.assertEquals((Object)"ABCD", (Object)((StringBuilder)this.out.getAppendable()).toString());
    }

    @Test
    public void testAppendCharSequence() throws Exception {
        String testData = "ABCD";
        this.out.append((CharSequence)"ABCD");
        this.out.append(null);
        Assertions.assertEquals((Object)"ABCDnull", (Object)((StringBuilder)this.out.getAppendable()).toString());
    }

    @Test
    public void testAppendSubSequence() throws Exception {
        String testData = "ABCD";
        this.out.append((CharSequence)"ABCD", 1, 3);
        this.out.append(null, 1, 3);
        Assertions.assertEquals((Object)("ABCD".substring(1, 3) + "ul"), (Object)((StringBuilder)this.out.getAppendable()).toString());
    }

    @Test
    public void testAppendChar() throws Exception {
        this.out.append('F');
        Assertions.assertEquals((Object)"F", (Object)((StringBuilder)this.out.getAppendable()).toString());
    }
}

